/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.OptionalPredicate;
import com.minecolonies.api.util.constant.TagConstants;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import java.util.List;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingSawmill
extends AbstractBuilding {
    private static final String SAWMILL = "sawmill";
    private static final double MIN_PERCENTAGE_TO_CRAFT = 0.75;

    public BuildingSawmill(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return SAWMILL;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(TagConstants.CRAFTING_SAWMILL).combine(super.getIngredientValidator());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            Optional<Boolean> isRecipeAllowed = CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, TagConstants.CRAFTING_SAWMILL);
            if (isRecipeAllowed.isPresent()) {
                return isRecipeAllowed.get();
            }
            double amountOfValidBlocks = 0.0;
            double blocks = 0.0;
            for (List<ItemStack> stacks : recipe.getInputs()) {
                ItemStack stack;
                if (stacks.isEmpty() || ItemStackUtils.isEmpty(stack = stacks.get(0)).booleanValue()) continue;
                if (stack.func_77973_b().func_206844_a((ITag)ItemTags.field_199905_b) || stack.func_77973_b().func_206844_a((ITag)ItemTags.field_200038_h)) {
                    amountOfValidBlocks += (double)stack.func_190916_E();
                    continue;
                }
                for (ResourceLocation tag : stack.func_77973_b().getTags()) {
                    if (!tag.func_110623_a().contains("wood")) continue;
                    amountOfValidBlocks += (double)stack.func_190916_E();
                    break;
                }
                blocks += (double)stack.func_190916_E();
            }
            return amountOfValidBlocks > 0.0 && amountOfValidBlocks / blocks > 0.75;
        }
    }
}

